﻿namespace Hims.Api.Controllers
{
    using System.Threading.Tasks;
    using Domain.Services;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;
    using Utilities;

    /// <summary>
    /// The patient device details controller.
    /// </summary>
    [Authorize]
    [Route("api/doctor-device-details")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class PatientDeviceDetailsController : BaseController
    {
        /// <summary>
        /// The services.
        /// </summary>
        private readonly IPatientDeviceDetailsService patientDeviceDetailsServices;

        /// <inheritdoc />
        public PatientDeviceDetailsController(IPatientDeviceDetailsService patientDeviceDetailsServices) => this.patientDeviceDetailsServices = patientDeviceDetailsServices;

        /// <summary>
        /// The fetch.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("fetch")]
        [ProducesResponseType(typeof(string), 200)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> FetchAsync([FromBody] VideoCallHistoryFilterModel model)
        {
            var response = await this.patientDeviceDetailsServices.FetchAsync(model.AppointmentId);

            return this.Success(response);
        }

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - added.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("add")]
        [ProducesResponseType(typeof(string), 200)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> AddAsync([FromBody] PatientDeviceDetailsModel model)
        {
            var response = await this.patientDeviceDetailsServices.InsertAsync(model);
            return this.Success(response);
        }
    }
}